/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.electronwill.nightconfig.core.Config;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class HighlighterConfig {
    public static final ForgeConfigSpec SPEC;
    public static final HighlighterConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue clearOnInventoryClose;
    public final ForgeConfigSpec.BooleanValue clearOnHover;
    public final ForgeConfigSpec.BooleanValue useItemNameColor;

    public HighlighterConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("options");
        this.clearOnInventoryClose = build.comment(" If new item markers should be cleared when the inventory is closed.").define("clear_on_close", true);
        this.clearOnHover = build.comment(" If new item markers should be cleared when the item tooltip is displayed.").define("clear_on_hover", true);
        this.useItemNameColor = build.comment(" If icons should match the color of items names (as shown in tooltips).  Otherwise icons will all be gold.").define("item_name_color", false);
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading e) {
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(HighlighterConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (HighlighterConfig)specPair.getLeft();
    }
}

